/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm;

import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.DestinationPanel;
import ibm.nways.jdm.GraphicPanelProducer;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.RemoteModel;

public class NavigationDestination {
    private RemoteModel model;
    private Class panelClass;
    private DestinationPanel panel;
    private GraphicPanelProducer graphicPanelProducer;

    private void initPanelClassName(String string) {
        try {
            this.panelClass = Class.forName(string);
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Destination class " + string + " not found");
            return;
        }
    }

    public NavigationDestination(String string) {
        this(string, null, null);
    }

    public NavigationDestination(String string, RemoteModel remoteModel) {
        this(string, remoteModel, null);
    }

    public NavigationDestination(String string, RemoteModel remoteModel, GraphicPanelProducer graphicPanelProducer) {
        if (string != null) {
            this.initPanelClassName(string);
        }
        this.setModel(remoteModel);
        this.setGraphicPanelProducer(graphicPanelProducer);
    }

    public void setModel(RemoteModel remoteModel) {
        this.model = remoteModel;
    }

    public RemoteModel getModel() {
        return this.model;
    }

    public DestinationPanel getPanel() {
        return this.panel;
    }

    public DestinationPanel newPanel(BrowserApplet browserApplet, NavigationContext navigationContext) {
        try {
            this.panel = (DestinationPanel)this.panelClass.newInstance();
            this.panel.setModel(this.model);
            this.panel.setNavContext(navigationContext);
            this.panel.setBrowser(browserApplet);
            this.panel.initDestPanel();
        }
        catch (InstantiationException instantiationException) {
            System.out.println("InstantiationException:" + instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println("IllegalAccessException:" + illegalAccessException.getMessage());
        }
        return this.panel;
    }

    public void setGraphicPanelProducer(GraphicPanelProducer graphicPanelProducer) {
        this.graphicPanelProducer = graphicPanelProducer;
    }

    public GraphicPanelProducer getGraphicPanelProducer() {
        return this.graphicPanelProducer;
    }
}

